# Introduction to ChromaDB

Welcome to the introduction guide for ChromaDB. This guide will help you get started with using ChromaDB in your Python applications.

## Client Version Overview

In this tutorial, we will be using the client version of ChromaDB. The client version is an in-memory database, which offers several advantages:

- No additional setup or configuration required
- Perfect for learning and testing purposes
- Allows quick and easy experimentation with ChromaDB's features

> **Note:** Because it's in-memory, the data stored in the client will be lost when your Python script finishes running.

## Getting Started

1. Install the ChromaDB Python client:
   ```
   pip install chromadb
   ```

2. Clone this repository to your local machine.

3. Navigate to the `Introduction` folder.

4. Run the `intro.py` script:
   ```
   python intro.py
   ```
   This script initializes the ChromaDB client and checks if the service is up and running.

If everything is set up correctly, you should see a timestamp printed to your console, indicating that the service is alive.

## Next Steps

After confirming that ChromaDB is working correctly, you can start using it in your applications. Check out the other folders in this repository for more examples and usage scenarios.

---

For more information, visit the [ChromaDB documentation](https://docs.trychroma.com/).
